/*
 * Diese Datei ist Teil des GDialog Projektes:
 * "Gigaset-Erweiterung fr ProjectX"
 * 
 * Das GDialog Projekt ist freigegeben unter
 * der GNU Public Licence (GPL), deren Text sich in
 * dem Quellen-Verzeichnis befindet. Ist er dort nicht
 * mehr vorhanden, so kann er unter http://www.gnu.org/licenses/gpl.html
 * eingesehen werden.
 */
package de.m740.projectx.gigaset;

import java.awt.BorderLayout;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.Settings;

/**
 * 26.01.2005
 * 
 * @author truels
 * 
 */
public class GPanelLocal extends GPanelAbstract {

    // ----------------------------------------------------------
    class FileComparator implements Comparator {

        public int compare(Object arg0, Object arg1) {
            try {
                String tmpFN0 = (String) arg0;
                String tmpFN1 = (String) arg1;
                return -tmpFN0.compareTo(tmpFN1);
            } catch (Exception e) {
                // ignore
            }
            return 0;
        }

    }

    // ----------------------------------------------------------
    private static final long serialVersionUID = 1L;

    private static final String PROPERTY_AUFNAHME_VERZEICHNIS = "gigaset.record.dir";

    private static final String FN_AUFNAHME_VERZEICHNIS = "gigaset-aufnahme-verzeichnis.txt";

    private static final String T = "" + File.separatorChar;

    private File flAufnahmeOrdner = new File(System.getProperty("user.dir"));

    private JButton btnAufnahmeOrdner = new JButton();

    private JButton btnRefresh = new JButton(GStrings
            .getString("gdialog.refresh"));

    private JFileChooser fcAufnahmeOrdner = new JFileChooser(flAufnahmeOrdner);

    private FileComparator aFileComparator = null;

    /**
     * 
     * Constructor for this class
     * 
     * @param inpDialog
     */
    public GPanelLocal(GDialog inpDialog) {
        super();
        setDialog(inpDialog);
        buildPanel();
    }

    protected void buildPanel() {
        setLayout(new BorderLayout());
        fcAufnahmeOrdner.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        flAufnahmeOrdner = readAufnahmeordner();
        String tmpString = String.valueOf(flAufnahmeOrdner);
        btnAufnahmeOrdner.setText(shortPathOf(tmpString));
        btnAufnahmeOrdner.setToolTipText(tmpString);
        // sucheAufnahmen();

        // Buttons top
        JPanel tmpPanelTop = new JPanel(new GridLayout(1, 2));
        tmpPanelTop.add(btnAufnahmeOrdner);
        tmpPanelTop.add(btnRefresh);
        // Buttons oben
        add(tmpPanelTop, BorderLayout.NORTH);
        // Aufnahmetabelle
        add(spAufnahmen, BorderLayout.CENTER);
        //
        ListSelectionModel tmpSelectionModel = aTableAufnahmen
                .getSelectionModel();
        tmpSelectionModel.addListSelectionListener(new ListSelectionListener() {
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    doEnabled();
                }
            }
        });

        aTableAufnahmen.addMouseListener(new MouseAdapter() {
            public void mouseClicked(MouseEvent event) {
                mouseClick(event);
            }
        });

        btnAufnahmeOrdner.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                getFcAufnahmeOrdner()
                        .setCurrentDirectory(getFlAufnahmeOrdner());
                if (getFcAufnahmeOrdner().showOpenDialog(null) == JFileChooser.APPROVE_OPTION) {
                    getDialog().zeigeInfos(-1);
                    setFlAufnahmeOrdner(getFcAufnahmeOrdner().getSelectedFile());
                    String tmpPathname = String.valueOf(getFlAufnahmeOrdner());
                    getBtnAufnahmeOrdner().setText(shortPathOf(tmpPathname));
                    getBtnAufnahmeOrdner().setToolTipText(tmpPathname);
                    // Common.getSettings().setProperty(PROPERTY_AUFNAHME_VERZEICHNIS,
                    // tmpPathname);
                    try {
                        RandomAccessFile konfDatei = new RandomAccessFile(
                                FN_AUFNAHME_VERZEICHNIS, "rw");
                        konfDatei.setLength(0);
                        konfDatei.writeBytes(getFlAufnahmeOrdner().toString());
                        konfDatei.close();
                    } catch (IOException e2) {
                    }
                    sucheAufnahmen();
                }
            }
        });

        btnRefresh.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                sucheAufnahmen();
            }
        });

    }

    /**
     * 
     */
    private File readAufnahmeordner() {
        File tmpFile = null;
        try {
            Settings tmpSettings = Common.getSettings();
            String tmpProp = PROPERTY_AUFNAHME_VERZEICHNIS;
            String tmpFN = tmpSettings.getProperty(tmpProp);
            if (tmpFN == null) {
                RandomAccessFile konfDatei = new RandomAccessFile(
                        FN_AUFNAHME_VERZEICHNIS, "r");
                tmpFN = konfDatei.readLine();
                konfDatei.close();
            }
            tmpFile = new File(tmpFN);
            if (!tmpFile.exists()) {
                tmpFile = new File(System.getProperty("user.dir"));
            }
            tmpFN = String.valueOf(tmpFile);
            // tmpSettings.setProperty(tmpProp, tmpFN);
        } catch (IOException e) {
        }
        return tmpFile;
    }

    /**
     * 
     * @param inpAufnahmeOrdner
     */
    private void sucheAufnahmen2(File inpAufnahmeOrdner) {
        clearSelection();
        aTableModel.clear();
        aTableModel.fireTableDataChanged();
        fireStateChanged();
        //
        if (inpAufnahmeOrdner != null && inpAufnahmeOrdner.isDirectory()) {
            String cridDateien[] = inpAufnahmeOrdner.list(new FilenameFilter() {
                public boolean accept(File f, String s) {
                    return s.toLowerCase().endsWith(".crid");
                }
            });
            int anz = (cridDateien == null) ? 0 : cridDateien.length;
            if (anz > 1) {
                Arrays.sort(cridDateien, getFileComparator());
                setSortSelector(SORT_FILES_NO);
            }
            aAufnahmen = new ArrayList(anz);
            HashMap tmpHash = new HashMap(anz);
            for (int i = 0; i < anz; i++) {
                try {
                    String tmpFN = cridDateien[i];
                    GAufnahmeLocal tmpAufnahme = new GAufnahmeLocal(
                            inpAufnahmeOrdner + T + tmpFN);
                    if (tmpAufnahme.isValid()) {
                        aAufnahmen.add(tmpAufnahme);
                        addAufnahme(i, tmpAufnahme, tmpHash);
                    } else {
                        GConsole.setMessage("Invalid file " + tmpFN
                                + " skipped!");
                    }
                } catch (Exception exc) {
                    GConsole.setErrorMessage(exc);
                }
            } // for i
            countChildren(GPanelTableIF.SORT_FILES_ON);
            // evtl letzte Tree-nderungen sichtbar machen
            aTableModel.fireTableRowsUpdated(0, aTableModel.getRowCount() - 1);
            tmpHash = null;

            if (aTableModel.getRowCount() == 0) {
                // falls keine Aufnahmen vorh.
                getDialog().zeigeInfos(-1); // soll auch nix angezeigt w.!
            }
        }
    }

    /**
     * 
     * @param inpAufnahmeOrdner
     */
    protected void sucheAufnahmen1(File inpAufnahmeOrdner) {
        try {
            sucheAufnahmen2(inpAufnahmeOrdner);
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        } finally {
            btnAufnahmeOrdner.setEnabled(true);
            btnRefresh.setEnabled(true);
        }
    }

    /**
     * 
     */
    public List getSelectedRecording() {
        try {
            GAufnahmeIF tmpAufnahme = getSelectedAufnahme();
            GConsole.setMessage("Get selected recording: "
                    + tmpAufnahme.getTitel());
            return tmpAufnahme.getMpgFiles();
        } catch (RuntimeException exc) {
            GConsole.setErrorMessage(exc);
        }
        return null; // error
    }

    /**
     * 
     */
    public void sucheAufnahmen() {
        Runnable tmpRunnable = new Runnable() {
            public void run() {
                try {
                    sucheAufnahmen1(getFlAufnahmeOrdner());
                } catch (Exception exc) {
                    GConsole.setErrorMessage(exc);
                }
            }

        };
        try {
            btnAufnahmeOrdner.setEnabled(false);
            btnRefresh.setEnabled(false);
            GConsole.clear();
            if (EventQueue.isDispatchThread()) {
                new Thread(tmpRunnable).start();
            } else {
                EventQueue.invokeLater(tmpRunnable);//
            }
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
    }

    protected GTable getTableAufnahmen() {
        return aTableAufnahmen;
    }

    protected JFileChooser getFcAufnahmeOrdner() {
        return fcAufnahmeOrdner;
    }

    protected JButton getBtnAufnahmeOrdner() {
        return btnAufnahmeOrdner;
    }

    public File getFlAufnahmeOrdner() {
        return flAufnahmeOrdner;
    }

    protected void setFlAufnahmeOrdner(File inpFlAufnahmeOrdner) {
        flAufnahmeOrdner = inpFlAufnahmeOrdner;
    }

    public void deleteSelectedAufnahme() {
        try {
            // int nr = aTableAufnahmen.getSelectedRow();
            GAufnahmeIF tmpAufnahme = getSelectedAufnahme();
            if (tmpAufnahme == null) {
                return;
            }
            File tmpCridFile = new File(tmpAufnahme.getCridFilename());
            String tmpWarning = "<html>" + tmpAufnahme.getTitel() + "<hr>"
                    + GStrings.getString("gdialog.delete.text") + " "
                    + flAufnahmeOrdner + " :<br>" + tmpCridFile.getName()
                    + "<br>";
            if (tmpAufnahme.istGesperrt()) {
                tmpWarning += "<hr> "
                        + GStrings.getString("gdialog.delete.locked") + " <hr>";
            }
            tmpWarning += "</html>";

            Toolkit.getDefaultToolkit().beep();
            if (JOptionPane.showConfirmDialog(null, tmpWarning, GStrings
                    .getString("gdialog.delete"), JOptionPane.WARNING_MESSAGE) == JOptionPane.OK_OPTION) // ;if(false)
            {
                boolean ok = tmpCridFile.delete();
                //
                aAufnahmen.remove(tmpAufnahme);
                // aTableModel.removeRow(nr);
                // aTableModel.fireTableDataChanged();
                GConsole.setInfo(tmpCridFile.getName() + (ok ? " " : " NOT ")
                        + "deleted");
                sortiereAufnahmen(getSortSelector());
            }
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
    }

    public void doEnabled() {
        GDialog tmpDialog = getDialog();
        int index = getTableAufnahmen().getSelectedRow();
        boolean enable = (index >= 0);
        tmpDialog.btnPrintEPG.setEnabled(enable);
        tmpDialog.aItemPlayMPC.setEnabled(enable);
        tmpDialog.aItemLoeschen.setEnabled(enable);
        tmpDialog.aItemReread.setEnabled(enable);
        tmpDialog.btnAuswaehlen.setEnabled(enable);
        tmpDialog.aItemAuswaehlen.setEnabled(enable);
        tmpDialog.btnHinzufuegen.setEnabled(enable);
        tmpDialog.aItemHinzufuegen.setEnabled(enable);
        tmpDialog.zeigeInfos(index);
    }

    /**
     * 
     * @return List of File (fmpg-directories)
     */
    public List getUsedRecDirectories() {
        List tmpList = null;
        int anza = (aAufnahmen == null) ? 0 : aAufnahmen.size();
        for (int i = 0; i < anza; i++) {
            GAufnahmeIF tmpAufnahmeIF = (GAufnahmeIF) aAufnahmen.get(i);
            if (tmpAufnahmeIF instanceof GAufnahmeLocal) {
                GAufnahmeLocal tmpAufnahme = (GAufnahmeLocal) tmpAufnahmeIF;
                File[] tmpFiles = tmpAufnahme.getFmpgDirectories();
                int anzf = (tmpFiles == null) ? 0 : tmpFiles.length;
                for (int j = 0; j < anzf; j++) {
                    File tmpFile = tmpFiles[j];
                    if (tmpFile == null) {
                        continue;
                    }
                    if (tmpList == null) {
                        tmpList = new ArrayList();
                    }
                    tmpList.add(tmpFile);
                    GConsole.setMessage("Used dir: "
                            + tmpFile.getAbsolutePath());
                } // for j
            } // if Local
        } // for i
        return tmpList;
    }

    /**
     * 
     * @param inpList
     *            List of File (fmpg-dirs)
     * @return File (.rec-directory)
     */
    public Object getLostDirectories(List inpList) {
        File tmpRecDir = null;
        try {
            GConsole.setMessage("*** Start searching lost directories ***");
            List inpUsedDirList = getUsedRecDirectories();
            if (inpUsedDirList == null) {
                return null;
            }
            int anzd = (inpUsedDirList == null) ? 0 : inpUsedDirList.size();
            tmpRecDir = getFlAufnahmeOrdner();
            if (tmpRecDir == null) {
                return null;
            }
            String tmpRecVerzeichnis = tmpRecDir.getAbsolutePath();
            if (!tmpRecVerzeichnis.endsWith(File.separator)) {
                tmpRecVerzeichnis += File.separator;
            }
            tmpRecVerzeichnis += ".rec" + File.separator;
            tmpRecDir = new File(tmpRecVerzeichnis);
            if (!tmpRecDir.exists()) {
                GConsole.setMessage("No directory " + tmpRecVerzeichnis
                        + " found!");
                return null;
            }
            //
            String tmpDirs[] = tmpRecDir.list(new FilenameFilter() {
                public boolean accept(File f, String s) {
                    if (!f.isDirectory()) {
                        return false;
                    }
                    return s.toLowerCase().endsWith(".fmpg");
                }
            });

            // change name to file
            List tmpList = null;
            anzd = (tmpDirs == null) ? 0 : tmpDirs.length;
            GConsole.setMessage(anzd + " fmpg-files found in .rec-dir");
            for (int i = 0; i < anzd; i++) {
                String tmpFN = tmpRecVerzeichnis + tmpDirs[i];
                File tmpFile = new File(tmpFN);
                if (tmpList == null) {
                    tmpList = new ArrayList();
                }
                tmpList.add(tmpFile);
                GConsole.setInfo(tmpFN);
            } // for

            inpList.clear();
            // nun vergleichen
            for (int i = 0; i < anzd; i++) {
                File tmpFile = (File) tmpList.get(i);
                if (!inpUsedDirList.contains(tmpFile)) {
                    inpList.add(tmpFile);
                    GConsole.setMessage("Lost dir: "
                            + tmpFile.getAbsolutePath());
                }
            } // for i
            anzd = (inpList == null) ? 0 : inpList.size();
            GConsole.setMessage(anzd + " lost directories found");
            GConsole.setMessage("*** End of searching lost directories ***");
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return tmpRecDir;

    }

    /**
     * @return fileComparator
     */
    private FileComparator getFileComparator() {
        if (aFileComparator == null) {
            aFileComparator = new FileComparator();
        }
        return aFileComparator;
    }

}
